var http = require('http');
var express = require('express');
var expressWs = require('..');

var app = express();
var server = http.createServer(app);

var router = express.Router();
var expressWs = expressWs(router, server);

app.use('/router', router);

router.use(function (req, res, next) {
  console.log('middleware');
  req.testing = 'testing';
  return next();
});

router.get('/', function(req, res, next){
  console.log('get route', req.testing);
  res.end();
});

router.ws('/', function(ws, req) {
  ws.on('message', function(msg) {
    console.log(msg);
  });
  console.log('socket', req.testing);
});

server.listen(3000)
